/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import net.minecraft.core.BlockPos;

public class StringCodecs {
    public static Codec<String> sized(int maxLength) {
        return StringCodecs.sized(0, maxLength);
    }

    public static Codec<String> sized(int minLength, int maxLength) {
        return Codec.STRING.comapFlatMap(str -> {
            if (str.length() < minLength || str.length() > maxLength) {
                return DataResult.error(() -> "String length out of bounds: " + str.length() + ", expected range [" + minLength + "-" + maxLength + "]");
            }
            return DataResult.success((Object)str);
        }, Function.identity());
    }

    public static Codec<BlockPos> blockPos() {
        return StringCodecs.stringifyCodec(str -> {
            String[] parts = str.split(";");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid BlockPos string format: " + str);
            }
            return new BlockPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }, pos -> String.format("%s;%s;%s", pos.getX(), pos.getY(), pos.getZ()));
    }

    public static <T> Codec<T> stringifyCodec(Function<String, T> fromString, Function<T, String> toString) {
        return Codec.STRING.comapFlatMap(str -> {
            try {
                return DataResult.success(fromString.apply((String)str));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Failed to parse string: " + str + " - " + e.getMessage());
            }
        }, toString);
    }
}

