/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import hellfirepvp.observerlib.common.util.RegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class CodecUtil {
    public static <T> Codec<Holder<T>> holderCodec(Registry<T> registry) {
        RegistryHelper regHelper = RegistryHelper.of(registry);
        return ResourceLocation.CODEC.flatXmap(key -> {
            Holder ref = regHelper.getOrNull((ResourceLocation)key);
            if (ref == null) {
                return DataResult.error(() -> "Unknown registry key: " + String.valueOf(key));
            }
            return DataResult.success(ref);
        }, holder -> {
            ResourceKey key = regHelper.unwrapOrNull((Holder)holder);
            if (key == null) {
                return DataResult.error(() -> "Unknown registry holder: " + String.valueOf(holder));
            }
            return DataResult.success((Object)key.location());
        });
    }

    public static <T> Codec<T> registryNameCodec(Registry<T> registry) {
        RegistryHelper regHelper = RegistryHelper.of(registry);
        return CodecUtil.holderCodec(registry).flatXmap(holder -> DataResult.success((Object)holder.value()), value -> {
            Holder<Object> holder = regHelper.getOrNull(value);
            if (holder == null) {
                return DataResult.error(() -> "Unknown registry value: " + String.valueOf(value));
            }
            return DataResult.success(holder);
        });
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static <T> T informedCast(Object obj, Class<T> target) {
        try {
            return (T)obj;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Failed to cast " + String.valueOf(obj) + " to " + String.valueOf(target), e);
        }
    }
}

