/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import hellfirepvp.observerlib.ObserverLib;
import hellfirepvp.observerlib.common.data.IWorldRelatedData;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import org.apache.commons.io.FileUtils;

public class WorldCacheIOThread
extends TimerTask {
    private static WorldCacheIOThread saveTask;
    private static Timer ioThread;
    private final Map<WorldCacheDomain, Map<ResourceLocation, List<IWorldRelatedData<?>>>> worldSaveQueue = Maps.newHashMap();
    private final Map<WorldCacheDomain, Map<ResourceLocation, List<IWorldRelatedData<?>>>> awaitingSaveQueue = Maps.newHashMap();
    private boolean inSave = false;
    private boolean skipTick = false;

    private WorldCacheIOThread() {
    }

    public static void onServerStart() {
        if (ioThread != null) {
            return;
        }
        saveTask = new WorldCacheIOThread();
        ioThread = new Timer("WorldCacheIOThread", true);
        ioThread.scheduleAtFixedRate((TimerTask)saveTask, 30000L, 30000L);
    }

    public static void onServerStop() {
        saveTask.flushAndSaveAll();
        saveTask.cancel();
        saveTask = null;
        ioThread.cancel();
        ioThread = null;
    }

    @Override
    public void run() {
        if (this.skipTick) {
            return;
        }
        this.inSave = true;
        this.saveAllNow();
        this.worldSaveQueue.clear();
        for (WorldCacheDomain domain : this.awaitingSaveQueue.keySet()) {
            for (Map.Entry<ResourceLocation, List<IWorldRelatedData<?>>> entry : this.awaitingSaveQueue.get(domain).entrySet()) {
                this.worldSaveQueue.computeIfAbsent(domain, d -> new HashMap()).put(entry.getKey(), entry.getValue());
            }
        }
        this.awaitingSaveQueue.clear();
        this.inSave = false;
    }

    private void flushAndSaveAll() {
        this.skipTick = true;
        for (WorldCacheDomain domain : this.awaitingSaveQueue.keySet()) {
            for (Map.Entry<ResourceLocation, List<IWorldRelatedData<?>>> entry : this.awaitingSaveQueue.get(domain).entrySet()) {
                this.worldSaveQueue.computeIfAbsent(domain, d -> new HashMap()).put(entry.getKey(), entry.getValue());
            }
        }
        this.saveAllNow();
        this.worldSaveQueue.clear();
        this.awaitingSaveQueue.clear();
        this.skipTick = false;
        this.inSave = false;
    }

    static void scheduleSave(WorldCacheDomain domain, ResourceLocation dimTypeName, IWorldRelatedData<?> worldRelatedData) {
        WorldCacheIOThread tr = saveTask;
        if (saveTask == null) {
            return;
        }
        if (tr.inSave) {
            tr.awaitingSaveQueue.computeIfAbsent(domain, d -> new HashMap()).computeIfAbsent(dimTypeName, id -> new ArrayList()).add(worldRelatedData);
        } else {
            tr.worldSaveQueue.computeIfAbsent(domain, d -> new HashMap()).computeIfAbsent(dimTypeName, id -> new ArrayList()).add(worldRelatedData);
        }
    }

    @Nonnull
    static <T extends IWorldRelatedData<T>> T loadNow(WorldCacheDomain domain, Level world, WorldCacheDomain.SaveKey<T> key) {
        T loaded = WorldCacheIOThread.loadDataFromFile(domain, world.dimension().location(), key);
        loaded.onLoad(world);
        return loaded;
    }

    private void saveAllNow() {
        for (WorldCacheDomain domain : this.worldSaveQueue.keySet()) {
            for (Map.Entry<ResourceLocation, List<IWorldRelatedData<?>>> entry : this.worldSaveQueue.get(domain).entrySet()) {
                entry.getValue().forEach(data -> this.saveNow(domain, (ResourceLocation)entry.getKey(), (IWorldRelatedData<?>)data));
            }
        }
    }

    private void saveNow(WorldCacheDomain domain, ResourceLocation dimTypeName, IWorldRelatedData<?> data) {
        try {
            WorldCacheIOThread.saveDataToFile(domain.getSaveDirectory(), dimTypeName, data);
        }
        catch (IOException e) {
            ObserverLib.log.warn("Unable to save WorldData!");
            ObserverLib.log.warn("Affected data: Dim=" + String.valueOf(dimTypeName) + " key=" + data.getSaveKey().getIdentifier());
            ObserverLib.log.warn("Printing StackTrace details...");
            e.printStackTrace();
        }
        data.markSaved();
    }

    private static void saveDataToFile(File baseDirectory, ResourceLocation dimTypeName, IWorldRelatedData<?> data) throws IOException {
        DirectorySet f = WorldCacheIOThread.getDirectorySet(baseDirectory, dimTypeName, data.getSaveKey());
        f.ensureDirectoriesExist();
        WorldCacheIOThread.writeDataToFile(data, f);
        data.writeAdditionalData(f.getActualDirectory(), f.getBackupDirectory());
    }

    private static <T extends IWorldRelatedData<T>> void writeDataToFile(IWorldRelatedData<T> data, DirectorySet f) throws IOException {
        WorldCacheDomain.SaveKey<T> saveKey = data.getSaveKey();
        File saveFile = saveKey.createAndBackupSaveFile(f.getActualDirectory(), f.getBackupDirectory());
        Codec<T> dataCodec = data.getSaveKey().getInstanceCodec();
        Tag dataNbt = (Tag)dataCodec.encodeStart((DynamicOps)NbtOps.INSTANCE, data).getOrThrow();
        CompoundTag dataTag = new CompoundTag();
        dataTag.put("data", dataNbt);
        NbtIo.write((CompoundTag)dataTag, (Path)saveFile.toPath());
    }

    @Nonnull
    private static <T extends IWorldRelatedData<T>> T loadDataFromFile(WorldCacheDomain domain, ResourceLocation dimTypeName, WorldCacheDomain.SaveKey<T> key) {
        DirectorySet f = WorldCacheIOThread.getDirectorySet(domain.getSaveDirectory(), dimTypeName, key);
        IWorldRelatedData.FileLoader loader = WorldCacheIOThread.createLoadingContext(f, key);
        ObserverLib.log.info("Loading WorldData {}/{} for level {}", (Object)key.getDomainName().getNamespace(), (Object)key.getIdentifier(), (Object)dimTypeName);
        IWorldRelatedData loaded = loader.loadData(key.saveFileResolver(), key.getInstanceCodec()).map(dataTpl -> {
            ((IWorldRelatedData)dataTpl.getA()).readAdditionalData(((File)dataTpl.getB()).getParentFile(), loader);
            return (IWorldRelatedData)dataTpl.getA();
        }).orElseGet(key::newInstance);
        loaded.setLoader(loader);
        ObserverLib.log.info("Loading WorldData {}/{} for level {} finished", (Object)key.getDomainName().getNamespace(), (Object)key.getIdentifier(), (Object)dimTypeName);
        return (T)loaded;
    }

    private static <F> IWorldRelatedData.FileLoader<F> createLoadingContext(DirectorySet dirSet, WorldCacheDomain.SaveKey<?> rootKey) {
        String rootName = rootKey.saveFileResolver().resolveFile(new File("/")).getPath();
        return (fileResolver, codec) -> {
            CompoundTag dataTag;
            if (!dirSet.getActualDirectory().exists() && !dirSet.getBackupDirectory().exists()) {
                return Optional.empty();
            }
            String attemptName = fileResolver.resolveFile(new File("/")).getPath();
            boolean isSaveRoot = attemptName.equals(rootName);
            Object data = null;
            File dataFile = null;
            try {
                if (dirSet.getActualDirectory().exists() && (dataFile = fileResolver.resolveFile(dirSet.getActualDirectory())).exists()) {
                    dataTag = NbtIo.read((Path)dataFile.toPath());
                    data = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)dataTag.get("data")).getOrThrow(IOException::new);
                }
            }
            catch (Exception exc) {
                ObserverLib.log.warn("Loading level data {} failed for its actual save. Attempting load from backup.", isSaveRoot ? rootKey.getIdentifier() : rootKey.getIdentifier() + attemptName);
            }
            if (data == null) {
                try {
                    if (dirSet.getBackupDirectory().exists() && (dataFile = fileResolver.resolveFile(dirSet.getBackupDirectory())).exists()) {
                        dataTag = NbtIo.read((Path)dataFile.toPath());
                        data = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)dataTag.get("data")).getOrThrow(IOException::new);
                    }
                }
                catch (Exception exc) {
                    ObserverLib.log.warn("Loading level data {} failed for its backup save. Copying erroneous files to error directory.", isSaveRoot ? rootKey.getIdentifier() : rootKey.getIdentifier() + attemptName);
                }
            }
            if (dataFile == null || !dataFile.exists()) {
                return Optional.empty();
            }
            if (data == null) {
                DirectorySet errorSet = dirSet.getErrorDirectories();
                try {
                    if (dirSet.getActualDirectory().exists()) {
                        FileUtils.copyDirectory((File)dirSet.getActualDirectory(), (File)errorSet.getActualDirectory());
                    }
                    if (dirSet.getBackupDirectory().exists()) {
                        FileUtils.copyDirectory((File)dirSet.getBackupDirectory(), (File)errorSet.getBackupDirectory());
                    }
                }
                catch (Exception e) {
                    ObserverLib.log.warn("Copying erroneous level data {} to the error directory failed.", isSaveRoot ? rootKey.getIdentifier() : rootKey.getIdentifier() + attemptName);
                    ObserverLib.log.error("Copying files failed.", (Throwable)e);
                }
                return Optional.empty();
            }
            return Optional.of(new Tuple(data, (Object)dataFile));
        };
    }

    private static synchronized DirectorySet getDirectorySet(File baseDirectory, ResourceLocation dimTypeName, WorldCacheDomain.SaveKey<?> key) {
        File worldDir = new File(baseDirectory, "DIM_" + WorldCacheIOThread.sanitizeFileName(dimTypeName.toString()));
        if (!worldDir.exists()) {
            worldDir.mkdirs();
        } else {
            WorldCacheIOThread.ensureFolder(worldDir);
        }
        return new DirectorySet(new File(worldDir, key.getIdentifier()));
    }

    private static void ensureFolder(File f) {
        if (!f.isDirectory()) {
            ObserverLib.log.warn("dataFile exists, but is a file instead of a folder! Please ensure that this is a folder/delete the file!");
            ObserverLib.log.warn("Encountered illegal state. Crashing to prevent further, harder to resolve errors!");
            throw new IllegalStateException("Affected file: " + f.getAbsolutePath());
        }
    }

    private static String sanitizeFileName(String name) {
        name = name.trim().replace(' ', '_').toLowerCase();
        for (char c0 : SharedConstants.ILLEGAL_FILE_CHARACTERS) {
            name = name.replace(c0, '_');
        }
        name = name.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
        return name;
    }

    private static class DirectorySet {
        private final File actualDirectory;
        private final File backupDirectory;

        private DirectorySet(File worldDirectory) {
            this.actualDirectory = worldDirectory;
            this.backupDirectory = new File(worldDirectory.getParent(), worldDirectory.getName() + "-Backup");
        }

        File getParentDirectory() {
            return this.getActualDirectory().getParentFile();
        }

        File getActualDirectory() {
            return this.actualDirectory;
        }

        File getBackupDirectory() {
            return this.backupDirectory;
        }

        DirectorySet getErrorDirectories() {
            File errorDirectory = new File(this.actualDirectory.getParent(), this.actualDirectory.getName() + "-Error");
            if (!errorDirectory.exists()) {
                errorDirectory.mkdirs();
            }
            return new DirectorySet(errorDirectory);
        }

        void ensureDirectoriesExist() {
            if (!this.getParentDirectory().exists()) {
                this.getParentDirectory().mkdirs();
            }
            if (!this.getActualDirectory().exists()) {
                this.getActualDirectory().mkdirs();
            }
            if (!this.getBackupDirectory().exists()) {
                this.getBackupDirectory().mkdirs();
            }
        }
    }
}

