/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import com.google.common.io.Files;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import hellfirepvp.observerlib.ObserverLib;
import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.IWorldRelatedData;
import hellfirepvp.observerlib.common.data.WorldCacheIOThread;
import hellfirepvp.observerlib.common.data.WorldCacheManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class WorldCacheDomain {
    private final ResourceLocation key;
    private final Set<SaveKey<? extends CachedWorldData<?>>> knownSaveKeys = new HashSet();
    private final Map<ResourceLocation, Map<SaveKey<?>, CachedWorldData<?>>> domainData = new HashMap();

    WorldCacheDomain(ResourceLocation key) {
        this.key = key;
    }

    public <T extends CachedWorldData<T>> SaveKey<T> createSaveKey(String name, Codec<T> dataCodec, Function<SaveKey<T>, T> dataProvider) {
        for (SaveKey<? extends CachedWorldData<?>> saveKey : this.knownSaveKeys) {
            if (!saveKey.identifier.equalsIgnoreCase(name)) continue;
            return saveKey;
        }
        SaveKey<T> key = new SaveKey<T>(this.getName(), name, dataCodec, dataProvider);
        this.knownSaveKeys.add(key);
        return key;
    }

    @Nullable
    public <T extends CachedWorldData<T>> SaveKey<T> getKey(String identifier) {
        for (SaveKey<? extends CachedWorldData<?>> saveKey : this.knownSaveKeys) {
            if (!saveKey.identifier.equalsIgnoreCase(identifier)) continue;
            return saveKey;
        }
        return null;
    }

    @Nonnull
    public Set<SaveKey<? extends CachedWorldData<?>>> getKnownSaveKeys() {
        return Collections.unmodifiableSet(this.knownSaveKeys);
    }

    public ResourceLocation getName() {
        return this.key;
    }

    @Nullable
    <T extends CachedWorldData<T>> T getCachedData(ResourceLocation dimTypeName, SaveKey<?> key) {
        return (T)((CachedWorldData)this.domainData.getOrDefault(dimTypeName, Collections.emptyMap()).get(key));
    }

    @Nullable
    private <T extends CachedWorldData<T>> T getFromCache(Level world, SaveKey<T> key) {
        return this.getCachedData(world.dimension().location(), key);
    }

    Collection<ResourceLocation> getUsedWorlds() {
        return this.domainData.keySet();
    }

    @Nonnull
    public <T extends CachedWorldData<T>> T getData(Level world, SaveKey<T> key) {
        Object data = this.getFromCache(world, key);
        if (data == null) {
            data = (CachedWorldData)WorldCacheIOThread.loadNow(this, world, key);
            this.domainData.computeIfAbsent(world.dimension().location(), i -> new HashMap()).put(key, data);
        }
        return data;
    }

    public File getSaveDirectory() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        File dataDir = server.getWorldPath(new LevelResource(this.key.getNamespace())).toFile();
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        return dataDir;
    }

    void clear() {
        this.domainData.clear();
    }

    public static class SaveKey<T extends IWorldRelatedData<T>> {
        public static final Codec<SaveKey<?>> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("domain").forGetter(SaveKey::getDomainName), (App)Codec.STRING.fieldOf("identifier").forGetter(SaveKey::getIdentifier)).apply((Applicative)inst, (domainKey, id) -> WorldCacheManager.findDomain(domainKey).map(domain -> domain.getKey((String)id)).orElseThrow(() -> new IllegalArgumentException("Unknown domain key: " + String.valueOf(domainKey) + " / " + id))));
        private final ResourceLocation domainName;
        private final String identifier;
        private final Codec<T> instanceCodec;
        private final Function<SaveKey<T>, T> instanceProvider;

        private SaveKey(ResourceLocation domainName, String identifier, Codec<T> instanceCodec, Function<SaveKey<T>, T> provider) {
            this.domainName = domainName;
            this.identifier = identifier;
            this.instanceCodec = instanceCodec;
            this.instanceProvider = provider;
        }

        public ResourceLocation getDomainName() {
            return this.domainName;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Codec<T> getInstanceCodec() {
            return this.instanceCodec;
        }

        public T newInstance() {
            return (T)((IWorldRelatedData)this.instanceProvider.apply(this));
        }

        public IWorldRelatedData.FileResolver saveFileResolver() {
            return directory -> directory.toPath().resolve(this.getIdentifier() + ".dat").toFile();
        }

        public File createAndBackupSaveFile(File saveDir, File backupDir) throws IOException {
            return this.createAndBackupSaveFile(saveDir, backupDir, this.saveFileResolver());
        }

        public File createAndBackupSaveFile(File saveDir, File backupDir, IWorldRelatedData.FileResolver fileResolver) throws IOException {
            File saveFile = fileResolver.resolveFile(saveDir);
            if (saveFile.exists()) {
                try {
                    Files.copy((File)saveFile, (File)fileResolver.resolveFile(backupDir));
                }
                catch (Exception exc) {
                    ObserverLib.log.info("Copying '{}' 's actual file to its backup file failed!", (Object)this.getIdentifier());
                    exc.printStackTrace();
                }
            } else {
                saveFile.createNewFile();
            }
            return saveFile;
        }
    }
}

