/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.change;

import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ObservableArea;
import hellfirepvp.observerlib.api.ObservableAreaBoundingBox;
import hellfirepvp.observerlib.api.block.BlockChangeSet;
import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.common.change.ObserverProviderStructure;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ChangeObserverStructure
extends ChangeObserver<ChangeObserverStructure> {
    private final ObserverProviderStructure provider;
    private final MatchableStructure structure;
    private final ObservableArea observedArea;
    private final Set<BlockPos> mismatches = new HashSet<BlockPos>();

    public ChangeObserverStructure(ObserverProviderStructure provider, MatchableStructure structure) {
        this.provider = provider;
        this.structure = structure;
        this.observedArea = new ObservableAreaBoundingBox(structure.getMinimumOffset(), structure.getMaximumOffset());
    }

    ChangeObserverStructure addMismatches(List<BlockPos> mismatches) {
        this.mismatches.addAll(mismatches);
        return this;
    }

    List<BlockPos> getMismatches() {
        return new ArrayList<BlockPos>(this.mismatches);
    }

    public ObserverProviderStructure getProvider() {
        return this.provider;
    }

    @Override
    public void initialize(LevelAccessor world, BlockPos center) {
        for (BlockPos offset : this.structure.getContents().keySet()) {
            if (this.structure.matchesSingleBlock((BlockGetter)world, center, offset)) continue;
            this.mismatches.add(offset);
        }
    }

    @Override
    @Nonnull
    public ObservableArea getObservableArea() {
        return this.observedArea;
    }

    @Override
    public boolean notifyChange(Level world, BlockPos center, BlockChangeSet changeSet) {
        for (BlockChangeSet.StateChange change : changeSet.getChanges()) {
            if (this.structure.hasBlockAt(change.getRelativePosition()) && !this.structure.matchesSingleBlock((BlockGetter)world, center, change.getRelativePosition(), change.getNewState(), world.getBlockEntity(center.offset((Vec3i)change.getRelativePosition())))) {
                this.mismatches.add(change.getRelativePosition());
                continue;
            }
            this.mismatches.remove(change.getRelativePosition());
        }
        this.mismatches.removeIf(mismatchPos -> !this.structure.hasBlockAt((BlockPos)mismatchPos));
        return this.mismatches.isEmpty();
    }
}

