/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.change;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import hellfirepvp.observerlib.api.block.BlockChangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateChangeSet
implements BlockChangeSet {
    public static final Codec<BlockStateChangeSet> CODEC = BlockStateChange.CODEC.listOf().xmap(BlockStateChangeSet::new, changeSet -> new ArrayList<BlockStateChange>(changeSet.changes.values()));
    private final Map<BlockPos, BlockStateChange> changes = Maps.newHashMap();

    public BlockStateChangeSet() {
    }

    private BlockStateChangeSet(List<BlockStateChange> changes) {
        changes.forEach(change -> this.changes.put(change.getRelativePosition(), (BlockStateChange)change));
    }

    public void addChange(BlockPos pos, BlockPos absolute, BlockState oldState, BlockState newState) {
        BlockStateChange oldChangeSet = this.changes.get(pos);
        if (oldChangeSet != null) {
            this.changes.put(pos, new BlockStateChange(pos, absolute, oldChangeSet.oldState, newState));
        } else {
            this.changes.put(pos, new BlockStateChange(pos, absolute, oldState, newState));
        }
    }

    public final void reset() {
        this.changes.clear();
    }

    @Override
    public boolean hasChange(BlockPos pos) {
        return this.changes.containsKey(pos);
    }

    @Override
    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<BlockChangeSet.StateChange> getChanges() {
        return Collections.unmodifiableCollection(this.changes.values());
    }

    public static final class BlockStateChange
    implements BlockChangeSet.StateChange {
        public static final Codec<BlockStateChange> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(BlockStateChange::getRelativePosition), (App)BlockPos.CODEC.fieldOf("abs").forGetter(BlockStateChange::getAbsolutePosition), (App)BlockState.CODEC.fieldOf("oldState").forGetter(BlockStateChange::getOldState), (App)BlockState.CODEC.fieldOf("newState").forGetter(BlockStateChange::getNewState)).apply((Applicative)builder, BlockStateChange::new));
        private final BlockPos pos;
        private final BlockPos abs;
        private final BlockState oldState;
        private final BlockState newState;

        private BlockStateChange(BlockPos pos, BlockPos abs, BlockState oldState, BlockState newState) {
            this.pos = pos;
            this.abs = abs;
            this.oldState = oldState;
            this.newState = newState;
        }

        @Override
        @Nonnull
        public BlockPos getAbsolutePosition() {
            return this.abs;
        }

        @Override
        @Nonnull
        public BlockPos getRelativePosition() {
            return this.pos;
        }

        @Override
        @Nonnull
        public BlockState getOldState() {
            return this.oldState;
        }

        @Override
        @Nonnull
        public BlockState getNewState() {
            return this.newState;
        }
    }
}

