/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.api;

import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.ObserverHelper;
import hellfirepvp.observerlib.api.ObserverProvider;
import hellfirepvp.observerlib.common.data.StructureMatchingBuffer;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.WorldCacheManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class MatcherObserverHelper
extends ObserverHelper {
    private static final WorldCacheDomain WORLD_DOMAIN = WorldCacheManager.createDomain("observerlib");
    private static final WorldCacheDomain.SaveKey<StructureMatchingBuffer> STRUCTURE_BUFFER_KEY = WORLD_DOMAIN.createSaveKey("structure_buffer", StructureMatchingBuffer.CODEC, StructureMatchingBuffer::new);

    public static StructureMatchingBuffer getBuffer(Level world) {
        return WORLD_DOMAIN.getData(world, STRUCTURE_BUFFER_KEY);
    }

    @Override
    @Nonnull
    public <T extends ChangeObserver<T>> ChangeSubscriber<T> observeArea(Level world, BlockPos center, ObserverProvider<T> provider) {
        return MatcherObserverHelper.getBuffer(world).observeArea(world, center, provider);
    }

    @Override
    public boolean removeObserver(Level world, BlockPos pos) {
        return MatcherObserverHelper.getBuffer(world).removeSubscriber(pos);
    }

    @Override
    @Nullable
    public ChangeSubscriber<? extends ChangeObserver<?>> getSubscriber(Level world, BlockPos pos) {
        return MatcherObserverHelper.getBuffer(world).getSubscriber(pos);
    }
}

