/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.client.preview;

import hellfirepvp.observerlib.client.preview.StructurePreview;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class StructurePreviewHandler {
    private static final StructurePreviewHandler INSTANCE = new StructurePreviewHandler();
    private StructurePreview currentPreview = null;

    private StructurePreviewHandler() {
    }

    public static StructurePreviewHandler getInstance() {
        return INSTANCE;
    }

    void setStructurePreview(StructurePreview preview) {
        if (this.currentPreview != null) {
            this.currentPreview.onRemove();
        }
        this.currentPreview = preview;
    }

    public void attachEventListeners(IEventBus bus) {
        bus.addListener(EventPriority.HIGH, this::render);
        bus.addListener(EventPriority.HIGH, this::clientTick);
    }

    private void render(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        ClientLevel renderWorld = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (renderWorld == null || player == null || this.currentPreview == null) {
            return;
        }
        if (this.currentPreview.canRender((Level)renderWorld, player.blockPosition())) {
            // empty if block
        }
    }

    private void clientTick(ClientTickEvent.Post event) {
        ClientLevel renderWorld = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (renderWorld == null || player == null) {
            this.currentPreview = null;
            return;
        }
        if (this.currentPreview != null) {
            if (!this.currentPreview.canPersist((Level)renderWorld, player.blockPosition())) {
                this.currentPreview.onRemove();
                this.currentPreview = null;
            } else {
                this.currentPreview.tick((Level)renderWorld, player.blockPosition());
            }
        }
    }
}

