/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.client.preview;

import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.api.util.StructureUtil;
import hellfirepvp.observerlib.client.preview.StructurePreviewHandler;
import hellfirepvp.observerlib.client.preview.StructureSnapshot;
import hellfirepvp.observerlib.client.util.ClientTickHelper;
import hellfirepvp.observerlib.client.util.SimpleBossInfo;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class StructurePreview {
    private static final RandomSource rand = RandomSource.create();
    private final ResourceKey<Level> dimension;
    private final BlockPos origin;
    private final StructureSnapshot snapshot;
    private double minimumDisplayDistanceSq = 64.0;
    private double displayDistanceMultiplier = 1.75;
    private BiPredicate<Level, BlockPos> persistenceTest = (world, pos) -> true;
    private Component barText = null;
    private SimpleBossInfo bossInfo = null;

    private StructurePreview(ResourceKey<Level> dimension, BlockPos origin, StructureSnapshot snapshot) {
        this.dimension = dimension;
        this.origin = origin;
        this.snapshot = snapshot;
    }

    public static Builder newBuilder(ResourceKey<Level> dimension, BlockPos source, MatchableStructure structure) {
        return StructurePreview.newBuilder(dimension, source, structure, ClientTickHelper.getClientTick());
    }

    public static Builder newBuilder(ResourceKey<Level> dimension, BlockPos source, MatchableStructure structure, long tick) {
        return new Builder(dimension, source, structure, tick);
    }

    private boolean isInRenderDistance(BlockPos position) {
        double distanceSq = Math.max(this.minimumDisplayDistanceSq, this.snapshot.getStructure().getMaximumOffset().distSqr(this.snapshot.getStructure().getMinimumOffset()));
        return this.origin.distSqr((Vec3i)position) <= (distanceSq *= Math.max(1.0, this.displayDistanceMultiplier));
    }

    boolean canRender(Level renderWorld, BlockPos renderPosition) {
        if (!this.dimension.equals((Object)renderWorld.dimension())) {
            return false;
        }
        return this.isInRenderDistance(renderPosition);
    }

    boolean canPersist(Level renderWorld, BlockPos position) {
        return this.persistenceTest.test(renderWorld, position);
    }

    public void tick(Level renderWorld, BlockPos position) {
        if (this.barText != null) {
            if (this.dimension.equals((Object)renderWorld.dimension()) && this.isInRenderDistance(position)) {
                if (this.bossInfo == null) {
                    this.bossInfo = SimpleBossInfo.create(this.barText, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
                    this.bossInfo.displayInfo();
                }
                float percFinished = (float)StructureUtil.getMismatches(this.snapshot.getStructure(), (BlockGetter)renderWorld, this.origin).size() / (float)this.snapshot.getStructure().getContents().size();
                this.bossInfo.setProgress(1.0f - percFinished);
            } else if (this.bossInfo != null) {
                this.bossInfo.removeInfo();
                this.bossInfo = null;
            }
        }
    }

    void onRemove() {
        if (this.bossInfo != null) {
            this.bossInfo.removeInfo();
        }
    }

    public static class Builder {
        private final StructurePreview preview;

        private Builder(ResourceKey<Level> dimension, BlockPos origin, MatchableStructure structure, long tick) {
            this.preview = new StructurePreview(dimension, origin, new StructureSnapshot(structure, tick));
        }

        public Builder setMinimumDisplayDistance(double minimumDisplayDistance) {
            this.preview.minimumDisplayDistanceSq = minimumDisplayDistance * minimumDisplayDistance;
            return this;
        }

        public Builder setDisplayDistanceMultiplier(double displayDistanceMultiplier) {
            this.preview.displayDistanceMultiplier = displayDistanceMultiplier;
            return this;
        }

        public Builder removeIfOutOfRenderDistance() {
            this.preview.persistenceTest = this.preview.persistenceTest.and((world, pos) -> this.preview.isInRenderDistance((BlockPos)pos));
            return this;
        }

        public Builder removeIfOutInDifferentWorld() {
            this.preview.persistenceTest = this.preview.persistenceTest.and((world, pos) -> this.preview.dimension.equals((Object)world.dimension()));
            return this;
        }

        public Builder andPersistOnlyIf(BiPredicate<Level, BlockPos> test) {
            this.preview.persistenceTest = this.preview.persistenceTest.and(test);
            return this;
        }

        public Builder showBar(Component headline) {
            this.preview.barText = headline;
            return this;
        }

        public StructurePreview buildAndSet() {
            StructurePreviewHandler.getInstance().setStructurePreview(this.preview);
            return this.preview;
        }
    }
}

