/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.util;

import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.util.BlockArray;
import hellfirepvp.observerlib.client.util.ClientTickHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public interface ContentSerializable {
    default public List<ItemStack> getAsStacks(LevelReader world, Player player) {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        ContentSerializable contentSerializable = this;
        if (!(contentSerializable instanceof BlockArray)) {
            return out;
        }
        BlockArray thisArray = (BlockArray)contentSerializable;
        long tick = ClientTickHelper.getClientTick();
        for (Map.Entry<BlockPos, MatchableState> structureEntry : thisArray.getContents().entrySet()) {
            BlockPos pos = structureEntry.getKey();
            BlockState sample = structureEntry.getValue().getDescriptiveState(tick);
            ItemStack stack = ItemStack.EMPTY;
            if (!sample.getFluidState().isEmpty() && sample.getFluidState().isSource()) {
                Fluid f = sample.getFluidState().getType();
                stack = FluidUtil.getFilledBucket((FluidStack)new FluidStack(f, 1000));
            }
            if (stack.isEmpty()) {
                try {
                    stack = sample.getCloneItemStack((HitResult)new BlockHitResult(Vec3.ZERO, Direction.UP, pos, false), world, pos, player);
                }
                catch (Exception f) {
                    // empty catch block
                }
            }
            if (stack.isEmpty()) continue;
            Item needle = stack.getItem();
            ItemStack existing = ItemStack.EMPTY;
            for (ItemStack i : out) {
                if (!i.getItem().equals(needle)) continue;
                existing = i;
                break;
            }
            if (existing.isEmpty()) {
                out.add(stack);
                continue;
            }
            existing.setCount(existing.getCount() + stack.getCount());
        }
        return out;
    }
}

