/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.structure;

import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.structure.Structure;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.TickPriority;

public interface PlaceableStructure
extends Structure {
    default public Map<BlockPos, BlockState> placeInWorld(LevelAccessor world, BlockPos center, Predicate<BlockPos> posFilter) {
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, ? extends MatchableState> entry : this.getContents().entrySet()) {
            MatchableTile<? extends BlockEntity> matchTile;
            BlockEntity placed;
            MatchableState match = entry.getValue();
            BlockPos at = center.offset((Vec3i)entry.getKey());
            if (!posFilter.test(at)) continue;
            BlockState state = match.getDescriptiveState(0L);
            BlockState existing = world.getBlockState(at);
            if (!existing.getFluidState().isEmpty() && existing.getFluidState().is(FluidTags.WATER) && state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (!world.setBlock(at, state, 3)) continue;
            result.put(at, state);
            if (!state.getFluidState().isEmpty()) {
                Fluid f = state.getFluidState().getType();
                world.scheduleTick(at, f, f.getTickDelay((LevelReader)world), TickPriority.HIGH);
            }
            if ((placed = world.getBlockEntity(at)) == null || !this.hasTileAt(entry.getKey()) || (matchTile = this.getTileEntityAt(entry.getKey())) == null) continue;
            matchTile.postPlacement((BlockEntity)placed, (BlockGetter)world, entry.getKey());
        }
        return result;
    }

    default public Map<BlockPos, BlockState> placeInWorld(LevelAccessor world, BlockPos center, Predicate<BlockPos> posFilter, PastPlaceProcessor processor) {
        Map<BlockPos, BlockState> result = this.placeInWorld(world, center, posFilter);
        if (processor != null) {
            for (Map.Entry<BlockPos, BlockState> entry : result.entrySet()) {
                if (!posFilter.test(entry.getKey())) continue;
                processor.process(world, entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static interface PastPlaceProcessor {
        public void process(LevelAccessor var1, BlockPos var2, BlockState var3);
    }
}

