/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.structure;

import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.structure.Structure;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface MatchableStructure
extends Structure {
    default public boolean matches(@Nonnull BlockGetter reader, @Nonnull BlockPos center) {
        for (Map.Entry<BlockPos, ? extends MatchableState> entry : this.getContents().entrySet()) {
            if (this.matchesSingleBlock(reader, center, entry.getKey())) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesSlice(@Nonnull BlockGetter reader, @Nonnull BlockPos center, int yOffset) {
        if (this.getMinimumOffset().getY() > yOffset || this.getMaximumOffset().getY() < yOffset) {
            return true;
        }
        for (BlockPos pos2 : this.getContents().keySet().stream().filter(pos -> pos.getY() == yOffset).toList()) {
            if (this.matchesSingleBlock(reader, center, pos2)) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesSingleBlock(@Nonnull BlockGetter reader, @Nonnull BlockPos center, @Nonnull BlockPos centerOffset) {
        return this.matchesSingleBlock(reader, center, centerOffset, reader.getBlockState(center.offset((Vec3i)centerOffset)), reader.getBlockEntity(center.offset((Vec3i)centerOffset)));
    }

    default public boolean matchesSingleBlock(@Nullable BlockGetter reader, @Nonnull BlockPos center, @Nonnull BlockPos centerOffset, @Nonnull BlockState comparing, @Nullable BlockEntity tileEntity) {
        if (!this.hasBlockAt(centerOffset)) {
            return false;
        }
        MatchableState state = this.getBlockStateAt(centerOffset);
        MatchableTile<? extends BlockEntity> tileMatch = this.getTileEntityAt(centerOffset);
        return state.matches(reader, center.offset((Vec3i)centerOffset), comparing) && (tileEntity == null || tileMatch == null || tileMatch.matches(reader, center.offset((Vec3i)centerOffset), (BlockEntity)tileEntity));
    }
}

