/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.block;

import hellfirepvp.observerlib.api.ObserverHelper;
import hellfirepvp.observerlib.common.block.BlockAirRequirement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface MatchableState {
    public static final MatchableState AIR = new MatchableState(){

        @Override
        @Nonnull
        public BlockState getDescriptiveState(long tick) {
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public boolean matches(@Nullable BlockGetter reader, @Nonnull BlockPos absolutePosition, @Nonnull BlockState state) {
            return state.isAir();
        }
    };
    public static final MatchableState REQUIRES_AIR = new MatchableState(){

        @Override
        @Nonnull
        public BlockState getDescriptiveState(long tick) {
            if (BlockAirRequirement.displayRequiredAir) {
                return ((Block)ObserverHelper.blockAirRequirement.get()).defaultBlockState();
            }
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public boolean matches(@Nullable BlockGetter reader, @Nonnull BlockPos absolutePosition, @Nonnull BlockState state) {
            return state.isAir();
        }
    };

    @Nonnull
    public BlockState getDescriptiveState(long var1);

    @Nullable
    default public BlockEntity createTileEntity(BlockGetter blockReader, BlockPos at, long tick) {
        BlockState state = this.getDescriptiveState(tick);
        if (state.getBlock() instanceof EntityBlock) {
            return ((EntityBlock)state.getBlock()).newBlockEntity(at, state);
        }
        return null;
    }

    public boolean matches(@Nullable BlockGetter var1, @Nonnull BlockPos var2, @Nonnull BlockState var3);
}

