/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;

public interface ObservableArea {
    public Collection<ChunkPos> getAffectedChunks(Vec3i var1);

    public boolean observes(Vec3i var1);

    default public Collection<ChunkPos> calculateAffectedChunks(AABB box, Vec3i offset) {
        AABB moved = box.move((double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
        return this.calculateAffectedChunks(new Vec3i(Mth.floor((double)moved.minX), Mth.floor((double)moved.minY), Mth.floor((double)moved.minZ)), new Vec3i(Mth.ceil((double)moved.maxX), Mth.ceil((double)moved.maxY), Mth.ceil((double)moved.maxZ)));
    }

    default public Collection<ChunkPos> calculateAffectedChunks(Vec3i min, Vec3i max) {
        ArrayList affected = Lists.newArrayList();
        int maxX = max.getX() >> 4;
        int maxZ = max.getZ() >> 4;
        for (int chX = min.getX() >> 4; chX <= maxX; ++chX) {
            for (int chZ = min.getZ() >> 4; chZ <= maxZ; ++chZ) {
                affected.add(new ChunkPos(chX, chZ));
            }
        }
        return affected;
    }
}

