package hellfirepvp.observerlib.api.client;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

/**
 * This class supports to render a structure, centered around structure origin 0, 0, 0.
 *
 * This class is part of the ObserverLib Mod
 * The complete source code for this mod can be found on github.
 * Class: RenderWorld
 * Created by HellFirePvP
 * Date: 30.04.2019 / 22:22
 */
@OnlyIn(Dist.CLIENT)
public class StructureRenderWorld /*implements LevelReader*/ {

    /*private static final int MAX_LIGHT = 15;

    private final Holder<Biome> globalBiome;
    private final SingleBiomeManager biomeManager;
    private final DimensionType thisDimType;
    private final WorldBorder maxBorder;

    private final Structure structure;
    private final Stack<Predicate<BlockPos>> blockFilter = new Stack<>();

    public StructureRenderWorld(Structure structure, Holder<Biome> globalBiome) {
        this.structure = structure;
        this.globalBiome = globalBiome;
        this.biomeManager = new SingleBiomeManager(this.globalBiome);
        DimensionType dimType = RegistryLookup.client().getValue(Registries.DIMENSION_TYPE, BuiltinDimensionTypes.OVERWORLD);
        if (dimType == null) {
            dimType = Iterables.getFirst(RegistryLookup.client().getValues(Registries.DIMENSION_TYPE), null);
        }
        this.thisDimType = dimType;

        if (this.thisDimType.coordinateScale() != 1.0D) {
            this.maxBorder = new WorldBorder() {
                public double getCenterX() {
                    return super.getCenterX() / thisDimType.coordinateScale();
                }

                public double getCenterZ() {
                    return super.getCenterZ() / thisDimType.coordinateScale();
                }
            };
        } else {
            this.maxBorder = new WorldBorder();
        }
    }

    public void pushContentFilter(@Nonnull Predicate<BlockPos> blockFilter) {
        this.blockFilter.push(blockFilter);
    }

    public void popContentFilter() {
        this.blockFilter.pop();
    }

    private boolean allowAccess(BlockPos pos) {
        for (Predicate<BlockPos> filter : this.blockFilter) {
            if (!filter.test(pos)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    @Override
    public BlockEntity getBlockEntity(BlockPos pos) {
        if (!this.structure.hasBlockAt(pos) || !allowAccess(pos)) {
            return null;
        }
        MatchableState state = this.structure.getBlockStateAt(pos);
        BlockEntity tile = state.createTileEntity(this, pos, ClientTickHelper.getClientTick());
        if (tile == null) {
            return null;
        }
        tile.setLevel(Minecraft.getInstance().level);

        MatchableTile tileMatch = this.structure.getTileEntityAt(pos);
        if (tileMatch == null) {
            return tile;
        }
        CompoundTag tag = tile.saveWithoutMetadata();
        tileMatch.writeDisplayData(tile, ClientTickHelper.getClientTick(), tag);
        tile.load(tag);

        tileMatch.postPlacement(tile, this, pos);
        return tile;
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        if (!this.structure.hasBlockAt(pos) || !allowAccess(pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        MatchableState state = this.structure.getContents().get(pos);
        return state == null ? Blocks.AIR.defaultBlockState() : state.getDescriptiveState(ClientTickHelper.getClientTick());
    }

    @Override
    public FluidState getFluidState(BlockPos pos) {
        return getBlockState(pos).getFluidState();
    }

    //Something with lighting and AO it seems?
    //Some light-multiplier based on direction? seems sketchy tbh
    @Override
    @OnlyIn(Dist.CLIENT)
    public float getShade(Direction direction, boolean b) {
        return 1F;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return new StructureRenderLightManager(MAX_LIGHT);
    }

    @Override
    public int getBrightness(LightLayer lightType, BlockPos blockPos) {
        return MAX_LIGHT;
    }

    @Override
    public int getRawBrightness(BlockPos pos, int amount) {
        return MAX_LIGHT;
    }

    @Override
    public int getMaxLightLevel() {
        return MAX_LIGHT;
    }

    @Nullable
    @Override
    public ChunkAccess getChunk(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return null;
    }

    @Override
    public boolean hasChunk(int chunkX, int chunkZ) {
        return false;
    }

    @Override
    public BlockPos getHeightmapPos(Heightmap.Types heightmapType, BlockPos pos) {
        return null;
    }

    @Override
    public RegistryAccess registryAccess() {
        return RegistryLookup.client().getRegistryAccess();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return FeatureFlags.DEFAULT_FLAGS;
    }

    @Override
    public int getHeight(Heightmap.Types heightmapType, int x, int z) {
        return 0;
    }

    @Override
    public int getSkyDarken() {
        return 0;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return biomeManager;
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return globalBiome;
    }

    @Override
    public WorldBorder getWorldBorder() {
        return maxBorder;
    }

    @Override
    public boolean isUnobstructed(@Nullable Entity entityIn, VoxelShape shape) {
        return true;
    }

    @Override
    public List<VoxelShape> getEntityCollisions(@Nullable Entity p_186427_, AABB p_186428_) {
        return Lists.newArrayList();
    }

    @Override
    public boolean isClientSide() {
        return true;
    }

    @Override
    public int getSeaLevel() {
        return 63;
    }

    @Override
    public DimensionType dimensionType() {
        return this.thisDimType;
    }*/
}
