/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.WorldCacheIOThread;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class WorldCacheManager {
    private static final String DEFAULT_DOMAIN_NAME = "worlddata";
    private static final WorldCacheManager instance = new WorldCacheManager();
    private static final Map<ResourceLocation, WorldCacheDomain> domains = new HashMap<ResourceLocation, WorldCacheDomain>();

    private WorldCacheManager() {
    }

    public static WorldCacheManager getInstance() {
        return instance;
    }

    public static void scheduleSaveAll() {
        for (WorldCacheDomain domain : domains.values()) {
            for (ResourceLocation dimTypeName : domain.getUsedWorlds()) {
                for (WorldCacheDomain.SaveKey<? extends CachedWorldData<?>> saveKey : domain.getKnownSaveKeys()) {
                    Object data = domain.getCachedData(dimTypeName, saveKey);
                    if (data == null || !((CachedWorldData)data).needsSaving()) continue;
                    WorldCacheIOThread.scheduleSave(domain, dimTypeName, data);
                }
            }
        }
    }

    public static void cleanUp() {
        for (WorldCacheDomain domain : domains.values()) {
            domain.clear();
        }
    }

    @Nonnull
    public static WorldCacheDomain createDomain(String modid) {
        ResourceLocation domainKey = ResourceLocation.fromNamespaceAndPath((String)modid, (String)DEFAULT_DOMAIN_NAME);
        WorldCacheDomain domain = new WorldCacheDomain(domainKey);
        domains.put(domainKey, domain);
        return domain;
    }

    public static Optional<WorldCacheDomain> findDomain(String modid) {
        return WorldCacheManager.findDomain(ResourceLocation.fromNamespaceAndPath((String)modid, (String)DEFAULT_DOMAIN_NAME));
    }

    public static Optional<WorldCacheDomain> findDomain(ResourceLocation domainKey) {
        for (ResourceLocation key : domains.keySet()) {
            if (!key.equals((Object)domainKey)) continue;
            return Optional.of(domains.get(key));
        }
        return Optional.empty();
    }

    public void doSave(Level world) {
        ResourceLocation worldName = world.dimension().location();
        for (WorldCacheDomain domain : domains.values()) {
            for (WorldCacheDomain.SaveKey<? extends CachedWorldData<?>> saveKey : domain.getKnownSaveKeys()) {
                Object data = domain.getCachedData(worldName, saveKey);
                if (data == null || !((CachedWorldData)data).needsSaving()) continue;
                WorldCacheIOThread.scheduleSave(domain, worldName, data);
            }
        }
    }
}

