/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.change;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.ObserverProvider;
import hellfirepvp.observerlib.api.block.BlockChangeSet;
import hellfirepvp.observerlib.common.api.MatcherObserverHelper;
import hellfirepvp.observerlib.common.change.BlockStateChangeSet;
import hellfirepvp.observerlib.common.registry.RegistryProviders;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MatchChangeSubscriber<T extends ChangeObserver<T>>
implements ChangeSubscriber<T> {
    public static final Codec<ChangeObserver<?>> OBSERVER_CODEC = RegistryProviders.getRegistry().byNameCodec().dispatch(ChangeObserver::getProvider, ObserverProvider::codec);
    public static final Codec<MatchChangeSubscriber<?>> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("center").forGetter(MatchChangeSubscriber::getCenter), (App)OBSERVER_CODEC.fieldOf("observer").forGetter(MatchChangeSubscriber::getObserver), (App)BlockStateChangeSet.CODEC.fieldOf("changeSet").forGetter(subscriber -> subscriber.changeSet), (App)Codec.BOOL.optionalFieldOf("isMatching").forGetter(subscriber -> Optional.ofNullable(subscriber.isMatching))).apply((Applicative)builder, MatchChangeSubscriber::new));
    private final BlockPos center;
    private final T observer;
    private final BlockStateChangeSet changeSet;
    private Boolean isMatching = null;
    private Collection<ChunkPos> affectedChunkCache = null;

    private MatchChangeSubscriber(BlockPos center, ChangeObserver<?> observer, BlockStateChangeSet changeSet, Optional<Boolean> isMatching) {
        this.center = center;
        this.observer = observer;
        this.changeSet = changeSet;
        this.isMatching = isMatching.orElse(null);
    }

    public MatchChangeSubscriber(BlockPos center, T observer) {
        this.center = center;
        this.observer = observer;
        this.changeSet = new BlockStateChangeSet();
    }

    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    @Nonnull
    public T getObserver() {
        return this.observer;
    }

    @Override
    @Nonnull
    public BlockChangeSet getCurrentChangeSet() {
        return this.changeSet;
    }

    public Collection<ChunkPos> getObservableChunks() {
        if (this.affectedChunkCache == null) {
            this.affectedChunkCache = Lists.newArrayList(((ChangeObserver)this.getObserver()).getObservableArea().getAffectedChunks((Vec3i)this.getCenter()));
        }
        return this.affectedChunkCache;
    }

    public boolean observes(BlockPos pos) {
        return ((ChangeObserver)this.getObserver()).getObservableArea().observes((Vec3i)pos.subtract((Vec3i)this.getCenter()));
    }

    public void addChange(BlockPos pos, BlockState oldState, BlockState newState) {
        this.changeSet.addChange(pos.subtract((Vec3i)this.getCenter()), pos, oldState, newState);
    }

    @Override
    public boolean isValid(Level world) {
        if (this.isMatching != null && this.changeSet.isEmpty()) {
            return this.isMatching;
        }
        this.isMatching = ((ChangeObserver)this.observer).notifyChange(world, this.getCenter(), this.changeSet);
        this.changeSet.reset();
        MatcherObserverHelper.getBuffer(world).markDirty((Vec3i)this.getCenter());
        return this.isMatching;
    }
}

