/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.util;

import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import hellfirepvp.observerlib.api.util.BlockArray;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.TickPriority;

public class StructureBlockArray
extends BlockArray
implements MatchableStructure {
    public <T extends LevelWriter & LevelReader> Map<BlockPos, BlockState> place(T levelAccess, BlockPos center) {
        return this.place(levelAccess, center, pos -> true);
    }

    public <T extends LevelWriter & LevelReader> Map<BlockPos, BlockState> place(T levelAccess, BlockPos center, Predicate<BlockPos> posFilter) {
        HashMap<BlockPos, BlockState> placedResult = new HashMap<BlockPos, BlockState>();
        this.getContents().forEach((offset, matchableState) -> {
            MatchableTile<? extends BlockEntity> matchTile;
            BlockEntity placedTile;
            BlockPos at = center.offset((Vec3i)offset);
            if (!posFilter.test(at)) {
                return;
            }
            BlockState state = matchableState.getDescriptiveState(0L);
            BlockState existing = ((BlockGetter)levelAccess).getBlockState(at);
            if (!existing.getFluidState().isEmpty() && existing.getFluidState().is(FluidTags.WATER) && state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (!levelAccess.setBlock(at, state, 3)) {
                return;
            }
            placedResult.put(at, state);
            if (levelAccess instanceof Level) {
                Level level = (Level)levelAccess;
                if (!state.getFluidState().isEmpty()) {
                    Fluid fluid = state.getFluidState().getType();
                    level.scheduleTick(at, fluid, fluid.getTickDelay((LevelReader)level), TickPriority.HIGH);
                }
            }
            if ((placedTile = ((BlockGetter)levelAccess).getBlockEntity(at)) != null && this.hasTileAt((BlockPos)offset) && (matchTile = this.getTileEntityAt((BlockPos)offset)) != null) {
                matchTile.postPlacement((BlockEntity)placedTile, (BlockGetter)levelAccess, (BlockPos)offset);
            }
        });
        return placedResult;
    }
}

