/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.client;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class StructureRenderLightManager
extends LevelLightEngine {
    private final int lightLevel;

    public StructureRenderLightManager(int lightLevel) {
        super((LightChunkGetter)FakeLightChunkGetter.INSTANCE, false, false);
        this.lightLevel = lightLevel;
    }

    public void checkBlock(BlockPos pPos) {
    }

    public boolean hasLightWork() {
        return false;
    }

    public int runLightUpdates() {
        return 0;
    }

    public void updateSectionStatus(BlockPos pPos, boolean pIsQueueEmpty) {
    }

    public void updateSectionStatus(SectionPos pPos, boolean pIsEmpty) {
    }

    public void setLightEnabled(ChunkPos pChunkPos, boolean pLightEnabled) {
    }

    public void propagateLightSources(ChunkPos pChunkPos) {
    }

    public LayerLightEventListener getLayerListener(LightLayer pType) {
        return new ConstantLightEngine(this.lightLevel);
    }

    public String getDebugData(LightLayer pLightLayer, SectionPos pSectionPos) {
        return "n/a";
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(LightLayer pLightLayer, SectionPos pSectionPos) {
        return LayerLightSectionStorage.SectionType.EMPTY;
    }

    public void queueSectionData(LightLayer pLightLayer, SectionPos pSectionPos, @Nullable DataLayer pDataLayer) {
    }

    public void retainData(ChunkPos pPos, boolean pRetain) {
    }

    public int getRawBrightness(BlockPos pBlockPos, int pAmount) {
        return super.getRawBrightness(pBlockPos, pAmount);
    }

    public boolean lightOnInSection(SectionPos pSectionPos) {
        return true;
    }

    public int getLightSectionCount() {
        return 0;
    }

    public int getMinLightSection() {
        return 0;
    }

    public int getMaxLightSection() {
        return 0;
    }

    private static class FakeLightChunkGetter
    implements LightChunkGetter {
        private static final FakeLightChunkGetter INSTANCE = new FakeLightChunkGetter();

        private FakeLightChunkGetter() {
        }

        @Nullable
        public LightChunk getChunkForLighting(int pChunkX, int pChunkZ) {
            return null;
        }

        public BlockGetter getLevel() {
            return FakeBlockGetter.INSTANCE;
        }
    }

    private record ConstantLightEngine(int lightLevel) implements LayerLightEventListener
    {
        @Nullable
        public DataLayer getDataLayerData(SectionPos pos) {
            return null;
        }

        public int getLightValue(BlockPos pos) {
            return this.lightLevel;
        }

        public void checkBlock(BlockPos pos) {
        }

        public boolean hasLightWork() {
            return false;
        }

        public int runLightUpdates() {
            return 0;
        }

        public void updateSectionStatus(SectionPos sectionPos, boolean isQueueEmpty) {
        }

        public void setLightEnabled(ChunkPos chPos, boolean isLightEnabled) {
        }

        public void propagateLightSources(ChunkPos chPos) {
        }
    }

    private static class FakeBlockGetter
    implements BlockGetter {
        private static final FakeBlockGetter INSTANCE = new FakeBlockGetter();

        private FakeBlockGetter() {
        }

        @Nullable
        public BlockEntity getBlockEntity(BlockPos pPos) {
            return null;
        }

        public BlockState getBlockState(BlockPos p_45571_) {
            return Blocks.AIR.defaultBlockState();
        }

        public FluidState getFluidState(BlockPos pPos) {
            return Fluids.EMPTY.defaultFluidState();
        }

        public int getHeight() {
            return 0;
        }

        public int getMinBuildHeight() {
            return 0;
        }
    }
}

