/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.block;

import hellfirepvp.observerlib.api.block.MatchableState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SimpleMatchableBlock
implements MatchableState {
    private static final int CYCLE_STATES = 20;
    private final List<Block> matchingBlocks;
    private final List<BlockState> displayStates = new ArrayList<BlockState>();

    public SimpleMatchableBlock(Block ... matchingBlocks) {
        this(Arrays.asList(matchingBlocks));
    }

    public SimpleMatchableBlock(List<Block> matchingBlocks) {
        this.matchingBlocks = matchingBlocks;
        for (Block b : this.matchingBlocks) {
            this.displayStates.addAll((Collection<BlockState>)b.getStateDefinition().getPossibleStates());
        }
    }

    @Override
    @Nonnull
    public BlockState getDescriptiveState(long tick) {
        int cycleState = Math.max(2, 20 / this.displayStates.size());
        int part = (int)(tick % (long)(cycleState * this.displayStates.size()));
        return this.displayStates.get(part / cycleState);
    }

    @Override
    public boolean matches(@Nullable BlockGetter reader, @Nonnull BlockPos absolutePosition, @Nonnull BlockState state) {
        return this.matchingBlocks.contains(state.getBlock());
    }
}

