package hellfirepvp.observerlib.client.preview;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

/**
 * This class is part of the ObserverLib Mod
 * The complete source code for this mod can be found on github.
 * Class: StructurePreviewHandler
 * Created by HellFirePvP
 * Date: 12.02.2020 / 18:23
 */
public class StructurePreviewHandler {

    private static final StructurePreviewHandler INSTANCE = new StructurePreviewHandler();

    private StructurePreview currentPreview = null;

    private StructurePreviewHandler() {}

    public static StructurePreviewHandler getInstance() {
        return INSTANCE;
    }

    void setStructurePreview(StructurePreview preview) {
        if (this.currentPreview != null) {
            this.currentPreview.onRemove();
        }
        this.currentPreview = preview;
    }

    public void attachEventListeners(IEventBus bus) {
        bus.addListener(EventPriority.HIGH, this::render);
        bus.addListener(EventPriority.HIGH, this::clientTick);
    }

    private void render(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) return;
        Level renderWorld = Minecraft.getInstance().level;
        Player player = Minecraft.getInstance().player;
        if (renderWorld == null || player == null || this.currentPreview == null) {
            return;
        }

        if (this.currentPreview.canRender(renderWorld, player.blockPosition())) {
            //this.currentPreview.render(renderWorld, event.getPoseStack(), player.position());
        }
    }

    private void clientTick(ClientTickEvent.Post event) {
        Level renderWorld = Minecraft.getInstance().level;
        Player player = Minecraft.getInstance().player;
        if (renderWorld == null || player == null) {
            this.currentPreview = null;
            return;
        }

        if (this.currentPreview != null) {
            if (!this.currentPreview.canPersist(renderWorld, player.blockPosition())) {
                this.currentPreview.onRemove();
                this.currentPreview = null;
            } else {
                this.currentPreview.tick(renderWorld, player.blockPosition());
            }
        }
    }
}
