/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.util;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryHelper<T> {
    private final Registry<T> registry;

    private RegistryHelper(Registry<T> registry) {
        this.registry = registry;
    }

    public static <T> RegistryHelper<T> of(Registry<T> registry) {
        return new RegistryHelper<T>(registry);
    }

    @Nonnull
    public ResourceKey<T> unwrapOrThrow(Holder<T> holder) {
        return (ResourceKey)holder.unwrap().mapRight(pValue -> (ResourceKey)this.registry.getResourceKey(pValue).orElseThrow()).map(Function.identity(), Function.identity());
    }

    @Nullable
    public ResourceKey<T> unwrapOrNull(Holder<T> holder) {
        return (ResourceKey)holder.unwrap().mapRight(pValue -> this.registry.getResourceKey(pValue).orElse(null)).map(Function.identity(), Function.identity());
    }

    @Nonnull
    public Holder<T> getOrThrow(T value) {
        ResourceKey typeKey = this.registry.getResourceKey(value).orElse(null);
        if (typeKey == null) {
            throw new IllegalArgumentException("Value not registered! " + this.getClass().getName());
        }
        return this.getOrThrow(typeKey);
    }

    @Nonnull
    public Holder<T> getOrThrow(String key) {
        return this.getOrThrow(ResourceLocation.parse((String)key));
    }

    @Nonnull
    public Holder<T> getOrThrow(ResourceLocation key) {
        return this.getOrThrow(ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)key));
    }

    @Nonnull
    public Holder<T> getOrThrow(ResourceKey<T> key) {
        return this.registry.getHolderOrThrow(key);
    }

    @Nullable
    public Holder<T> getOrNull(T value) {
        ResourceKey typeKey = this.registry.getResourceKey(value).orElse(null);
        if (typeKey == null) {
            return null;
        }
        return this.getOrNull(typeKey);
    }

    @Nullable
    public Holder<T> getOrNull(String key) {
        return this.getOrNull(ResourceLocation.parse((String)key));
    }

    @Nullable
    public Holder<T> getOrNull(ResourceLocation key) {
        return this.getOrNull(ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)key));
    }

    @Nullable
    public Holder<T> getOrNull(ResourceKey<T> key) {
        return this.registry.getHolder(key).orElse(null);
    }
}

