/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import hellfirepvp.observerlib.ObserverLib;
import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.ObservableArea;
import hellfirepvp.observerlib.api.ObserverProvider;
import hellfirepvp.observerlib.common.change.MatchChangeSubscriber;
import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.SectionWorldData;
import hellfirepvp.observerlib.common.data.base.WorldSection;
import hellfirepvp.observerlib.common.util.CodecUtil;
import hellfirepvp.observerlib.common.util.StringCodecs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class StructureMatchingBuffer
extends SectionWorldData<StructureMatchingBuffer, MatcherSectionData> {
    public static final Codec<StructureMatchingBuffer> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)WorldCacheDomain.SaveKey.CODEC.fieldOf("key").forGetter(CachedWorldData::getSaveKey)).apply((Applicative)builder, key -> new StructureMatchingBuffer((WorldCacheDomain.SaveKey)CodecUtil.cast(key))));

    public StructureMatchingBuffer(WorldCacheDomain.SaveKey<StructureMatchingBuffer> key) {
        super(key, MatcherSectionData.CODEC, 4);
    }

    @Override
    public MatcherSectionData createNewSection(int sectionX, int sectionZ) {
        return new MatcherSectionData(sectionX, sectionZ);
    }

    @Nonnull
    public <T extends ChangeObserver<T>> MatchChangeSubscriber<T> observeArea(Level world, BlockPos center, ObserverProvider<T> provider) {
        MatchChangeSubscriber existing = (MatchChangeSubscriber)this.getSubscriber(center);
        if (existing != null) {
            if (!((ChangeObserver)existing.getObserver()).getProvider().equals(provider)) {
                ObserverLib.log.warn("Trying to observe area at dim={} {} while it is already being observed by {}", (Object)world.dimension().location(), (Object)center.toString(), ((ChangeObserver)existing.getObserver()).getProvider());
                ObserverLib.log.warn("Removing existing observer!");
                this.write(() -> this.removeSubscriber(center));
            } else {
                return existing;
            }
        }
        T observer = provider.newObserver();
        MatchChangeSubscriber subscriber = new MatchChangeSubscriber(center, observer);
        for (ChunkPos chPos : subscriber.getObservableChunks()) {
            MatcherSectionData data = (MatcherSectionData)this.getOrCreateSection((Vec3i)chPos.getWorldPosition());
            this.write(() -> data.addSubscriber(center, subscriber));
            this.markDirty(data);
        }
        ((ChangeObserver)observer).initialize((LevelAccessor)world, center);
        return subscriber;
    }

    public boolean removeSubscriber(BlockPos pos) {
        MatcherSectionData data = (MatcherSectionData)this.getOrCreateSection((Vec3i)pos);
        ChangeSubscriber removed = this.write(() -> data.removeSubscriber(pos));
        if (removed != null) {
            ObservableArea area = ((ChangeObserver)removed.getObserver()).getObservableArea();
            for (ChunkPos chPos : area.getAffectedChunks((Vec3i)pos)) {
                MatcherSectionData matchData = (MatcherSectionData)this.getOrCreateSection((Vec3i)chPos.getWorldPosition());
                this.write(() -> matchData.removeSubscriber(pos));
                this.markDirty(matchData);
            }
        }
        return removed != null;
    }

    @Nullable
    public ChangeSubscriber<? extends ChangeObserver<?>> getSubscriber(BlockPos pos) {
        MatcherSectionData section = (MatcherSectionData)this.getSection((Vec3i)pos);
        if (section == null) {
            return null;
        }
        return this.read(() -> section.getSubscriber(pos));
    }

    @Nonnull
    public Collection<MatchChangeSubscriber<?>> getSubscribers(ChunkPos pos) {
        MatcherSectionData section = (MatcherSectionData)this.getSection((Vec3i)pos.getWorldPosition());
        if (section == null) {
            return List.of();
        }
        return this.read(() -> new ArrayList(section.requestSubscribers.values()));
    }

    public static class MatcherSectionData
    extends WorldSection {
        public static final Codec<MatcherSectionData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("sX").forGetter(WorldSection::getSectionX), (App)Codec.INT.fieldOf("sZ").forGetter(WorldSection::getSectionZ), (App)Codec.unboundedMap(StringCodecs.blockPos(), MatchChangeSubscriber.CODEC).fieldOf("subscribers").forGetter(section -> section.requestSubscribers)).apply((Applicative)builder, MatcherSectionData::new));
        private final Map<BlockPos, MatchChangeSubscriber<? extends ChangeObserver<?>>> requestSubscribers = new HashMap();

        private MatcherSectionData(int sX, int sZ) {
            super(sX, sZ);
        }

        private MatcherSectionData(int sX, int sZ, Map<BlockPos, MatchChangeSubscriber<? extends ChangeObserver<?>>> subscribers) {
            super(sX, sZ);
            this.requestSubscribers.putAll(subscribers);
        }

        @Nullable
        private MatchChangeSubscriber<? extends ChangeObserver<?>> getSubscriber(BlockPos pos) {
            return this.requestSubscribers.get(pos);
        }

        @Nullable
        private ChangeSubscriber<? extends ChangeObserver<?>> removeSubscriber(BlockPos pos) {
            return this.requestSubscribers.remove(pos);
        }

        @Nullable
        private ChangeSubscriber<? extends ChangeObserver<?>> addSubscriber(BlockPos pos, MatchChangeSubscriber<? extends ChangeObserver<?>> subscriber) {
            return this.requestSubscribers.put(pos, subscriber);
        }
    }
}

