/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.change;

import hellfirepvp.observerlib.api.block.BlockStructureObserver;
import hellfirepvp.observerlib.common.api.MatcherObserverHelper;
import hellfirepvp.observerlib.common.change.MatchChangeSubscriber;
import hellfirepvp.observerlib.common.data.StructureMatchingBuffer;
import hellfirepvp.observerlib.common.event.BlockChangeNotifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class StructureIntegrityObserver
implements BlockChangeNotifier.Listener {
    @Override
    public void onChange(Level world, LevelChunk chunk, BlockPos pos, BlockState oldState, BlockState newState) {
        if (world.isClientSide() || !chunk.getHighestGeneratedStatus().isOrAfter(ChunkStatus.FULL)) {
            return;
        }
        StructureMatchingBuffer buf = MatcherObserverHelper.getBuffer(world);
        ChunkPos ch = chunk.getPos();
        for (MatchChangeSubscriber<?> subscriber : buf.getSubscribers(ch)) {
            if (!subscriber.observes(pos)) continue;
            subscriber.addChange(pos, oldState, newState);
            buf.markDirty((Vec3i)pos);
        }
        if (oldState.getBlock() instanceof BlockStructureObserver && ((BlockStructureObserver)oldState.getBlock()).removeWithNewState(world, pos, oldState, newState)) {
            buf.removeSubscriber(pos);
        }
    }
}

