/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.util;

import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.api.structure.Structure;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;

public class StructureUtil {
    private StructureUtil() {
    }

    public static boolean isStructureLoaded(Structure structure, LevelAccessor world, BlockPos offset) {
        ChunkPos min = new ChunkPos(offset.offset(structure.getMinimumOffset()));
        ChunkPos max = new ChunkPos(offset.offset(structure.getMaximumOffset()));
        for (int xx = min.x; xx <= max.x; ++xx) {
            for (int zz = min.z; zz <= max.z; ++zz) {
                if (world.getChunkSource().hasChunk(xx, zz)) continue;
                return false;
            }
        }
        return true;
    }

    public static Optional<Integer> getLowestMismatchingSlice(MatchableStructure structure, BlockGetter world, BlockPos offset) {
        int minY = structure.getMinimumOffset().getY();
        int maxY = structure.getMaximumOffset().getY();
        for (int y = minY; y <= maxY; ++y) {
            if (structure.matchesSlice(world, offset, y)) continue;
            return Optional.of(y);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Set<BlockPos> getMismatches(MatchableStructure structure, BlockGetter world, BlockPos offset) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        structure.getContents().forEach((key, value) -> {
            if (!structure.matchesSingleBlock(world, offset, (BlockPos)key)) {
                result.add((BlockPos)key);
            }
        });
        return result;
    }
}

